#ifndef RESEAU_H_INCLUDED
#define RESEAU_H_INCLUDED

#define PORT 4444

#include <stdlib.h>
#include <SDL/SDL_thread.h>
#include <SDL/SDL_net.h>

#include "affichage.h"

typedef enum enum_type_message //Type des messages reus sur le rseau
{
    ERREUR_DECO = 0, //Erreur ou dconnexion
    MESSAGE = 1, //Message "crit" (chat, ...)
    VERSION = 2, //Numro de la version du jeu (Serveur et Client doivent correspondre) et Pseudo de connexion (client -> serveur)
    INFO = 3, //Info sur la partie : nombre de joueurs et numro du joueur (serveur -> client)
    PSEUDO = 4, //Envoie de pseudo (serveur -> client)
    BASE = 5, //Envoie de la position de dpart du joueur (serveur -> client)
    MAP = 6, //Envoie de la map (serveur -> client)
    TILESET = 7, //Envoie du tileset (serveur -> client)
    AJOUTER_PION = 8, //Envoie les donnes d'un pion (serveur -> client)
    EXPLORE = 9, //Envoie d'une ligne de terrain explor (serveur -> client)
    TOUR = 10, //Changement de tour
    DEPLACEMENT = 11, //Dplacement d'un pion
    PTS_MVT = 12, //Envoie des points restants (serveur -> client)
    COMBAT = 13, //Envoie le rsultat d'un combat (serveur -> client)
    MODIF_GRAAL = 14, //Envoie d'une modification du graal (lach(12)/port(8)) (serveur -> client)
    VICTOIRE = 15, //Message de fin de partie donnant le vainqueur et le perdant (serveur -> client)
    SAUVEGARDE = 16 //Demande de sauvegarde (client -> serveur)
}type_message;

typedef struct s_paquet //Structure d'un paquet reu du rseau
{
    type_message type; //Type du paquet
    long taille; //Taille des donnes
    char *donnee; //Donnes brutes
    struct s_paquet *suivant; //Pointeur sur le paquet suivant (reu aprs)
}t_paquet;

typedef struct s_joueur //Structure reprsentant un joueur
{
    TCPsocket socket; //Permet de communiquer avec le joueur  travers le rseau
    long ecoute; //Vaut -1 si le joueur n'est pas connect, 0 si le joueur vient de se dconnecter et 1 si le thread d'coute est lanc
    long pret; //Vaut Vrai si le joueur est prt
    long x, y; //Position de dpart du joueur
    char **explore; //Cases explores
    long campeur; //Vaut Vrai si le joueur campe prs de sa position de dpart
    t_paquet *paquets; //Contient la liste des paquets reus depuis le joueur et en attente de traitement
    SDL_Thread *thread_id; //Contient un identifiant sur le thread qui s'occupe de la rception des messages de ce joueur
}t_joueur;

typedef struct s_reseau
{
    TCPsocket serveur; //Sockets d'coute
    IPaddress adresse_serveur; //Adresse ip du serveur
    t_joueur *joueurs; //Contient les infos pour reprsenter les diffrents joueurs
    long port; //Port utiliser pour communiquer
    long nbr_clients; //Nombre de clients connects au serveur
    long nbr_joueurs; //Nombre de joueurs maximum pour le jeu
    char **pseudo; //Pseudo des joueurs dans l'ordre : cela permet de retrouver le bon slot lors du chargement d'une partie
    long ecoute; //Vaut Vrai si le serveur attend des connexions
    long chargee; //Vaut Vrai si la partie est charge depuis un fichier
}t_reseau;

long res_init(t_reseau *res); //Initialise le rseau
void res_quit(t_reseau *res); //Ferme le rseau
long changer_nbr_joueurs(t_reseau *res, long nbr); //Change nbr_joueurs et effectue les allocations/librations mmoires ncessaires
long lancer_serveur(TCPsocket *serveur, IPaddress *adresse_serveur, long port); //Mise en coute en tant que serveur
long nouveaux_joueurs(t_reseau *res, t_affichage *aff); //Vrifie si un nouveau joueur se connecte et gre la connexion si ncessaire
long accepter_joueur(t_joueur *joueur, TCPsocket serveur); //Accepte la connexion d'un joueur
void supprimer_joueur(t_reseau *res, long i); //Libre la mmoire alloue  un joueur
void supprimer_paquets(t_paquet *paquet); //Libre la mmoire alloue  une liste de paquets
void communiquer(type_message type, long taille, char *donnee, t_joueur joueur); //Envoie un paquet au joueur

#endif // RESEAU_H_INCLUDED
